function cmp=UpOperacija(Matrix)

Dim=size(Matrix);                             %  Citanje dimenzija matrice u formatu [m n]
m=Dim(1,1);                                   %i dodela odgovarajucih vrednosti promenljivoj m   
n=Dim(1,2);                                   %odnosno n.  
                                              %  Neophodno je da formiramo matricu formata (m-2,n),
if m<3                                        %a neophodan uslov je da je broj vrsta (m) veci od 3          
    
    error('Greska! Nedovoljan broj cvorova za izvrsavanje programa');
    
end                                           %  U suprotnom dolazi do prekida programa.
NewMatrix=[];                                 %  Inicijalizacija nove matrice.  
for i=2:m-1                                   %  U for ciklusu kopiramo vrstu po vrstu prvu matricu 
    NewMatrix(i-1,:)=Matrix(i,:);             %u drugu, izostavljajuci prvu i poslednju vrstu.   
end                                           %              
                                              %                  
%format compact                               %      
                                              %  Uporedjivanje se vrsi koristeci naredbe tic i toc.          
tic                                           %Tic startuje stopericu. Toc vraca proteklo vreme.   
for i=1:1000                                  %Merimo razliku izmedju proteklog vremena u prvom  
   NewtonPol(NewMatrix);                      %slucaju, sa iskoriscenih n-2 cvora interpolacije,   
end                                           %i drugom slucaju, gde su uzeti i cvorovi x0 i xn.  
firstnT=toc;                                  %Naravno, najpre za Newton-ov, a zatim i za Lagrange-ov  
                                              %polinom.  
tic                                           %  
for i=1:1000                                  %  Kako je vreme za koje se izvrsi navedena operacija
    NewtonPol(Matrix);                        %kratko, da bi razlika bila uocljivija u for ciklusu  
end                                           %pozivamo navedene funkcije 1000 puta.  
secondnT=toc;                                 %

fprintf('Razlika izmedju vremena izracunavanja\n');
fprintf('kod aporksimacije Newton-ovim interpolacionim polinomom\n');
fprintf('prvog i drugog slucaja je:\n');

differenceN=secondnT-firstnT                  %  Dobijena vremenska razlika izmedju drugog i prvog slucaja
                                              %
tic                                           %
for i=1:1000                                  %
    LagrangePol(NewMatrix);                   %
end                                           %
firstlT=toc;                                  %
                                              %
tic                                           %
for i=1:1000                                  %
    LagrangePol(Matrix);                      %
end                                           %
secondlT=toc;                                 %

fprintf('Razlika izmedju vremena izracunavanja\n');
fprintf('kod aporksimacije Lagranege-ovim interpolacionim polinomom\n');
fprintf('prvog i drugog slucaja je:\n');

differenceL=secondlT-firstlT                  %  Dobijena vremenska razlika izmedju drugog i prvog slucaja



